/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.object;

import com.freedomotic.model.geometry.FreedomShape;
import com.freedomotic.model.object.Behavior;
import com.freedomotic.model.object.Properties;
import com.freedomotic.model.object.Representation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"name", "description", "uuid", "protocol", "phisicalAddress", "type", "actAs", "representation", "currentRepresentation", "behaviors", "hierarchy", "actions", "triggers", "tags", "envUUID"})
public class EnvObject
implements Serializable {
    private static final long serialVersionUID = -7253889516478184321L;
    private String name;
    private String description;
    private String actAs;
    private String type;
    private String uuid;
    private String hierarchy;
    private String protocol;
    private String phisicalAddress;
    private final List<Behavior> behaviors = new ArrayList<Behavior>();
    private final List<Representation> representation = new ArrayList<Representation>();
    private Set<String> tags;
    private final Properties actions = new Properties();
    private Properties triggers = new Properties();
    private int currentRepresentation;
    private String envUUID;

    public String getEnvironmentID() {
        return this.envUUID;
    }

    public void setEnvironmentID(String uuid) {
        this.envUUID = uuid;
    }

    public Properties getActions() {
        return this.actions;
    }

    public Properties getTriggers() {
        if (this.triggers == null) {
            this.triggers = new Properties();
        }
        return this.triggers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setCurrentRepresentation(int index) {
        if (this.representation.get(index) != null) {
            this.currentRepresentation = index;
        }
    }

    public Representation getCurrentRepresentation() {
        return this.representation.get(this.currentRepresentation);
    }

    public int getCurrentRepresentationIndex() {
        return this.currentRepresentation;
    }

    public List<Representation> getRepresentations() {
        return this.representation;
    }

    public String getProtocol() {
        if (this.protocol == null || this.protocol.isEmpty()) {
            this.protocol = "unknown";
        }
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public ArrayList<Behavior> getActiveBehaviors() {
        ArrayList<Behavior> activeBehaviors = new ArrayList<Behavior>();
        for (Behavior behavior : this.behaviors) {
            if (!behavior.isActive()) continue;
            activeBehaviors.add(behavior);
        }
        return activeBehaviors;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public Behavior getBehavior(String behavior) {
        for (Behavior b : this.behaviors) {
            if (!b.getName().equalsIgnoreCase(behavior)) continue;
            return b;
        }
        return null;
    }

    public void setActAs(String actAs) {
        this.actAs = actAs;
    }

    public String getActAs() {
        return this.actAs;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getPhisicalAddress() {
        if (this.phisicalAddress == null || this.phisicalAddress.isEmpty()) {
            this.phisicalAddress = "unknown";
        }
        return this.phisicalAddress.trim();
    }

    public void setPhisicalAddress(String address) {
        this.phisicalAddress = address;
    }

    public FreedomShape getShape() {
        return this.getCurrentRepresentation().getShape();
    }

    public HashMap<String, String> getExposedProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("object.name", this.getName());
        result.put("object.address", this.getPhisicalAddress());
        result.put("object.protocol", this.getProtocol());
        result.put("object.type", this.getType());
        result.put("object.tags", this.getTagsString());
        result.put("object.uuid", this.getUUID());
        return result;
    }

    public String getSimpleType() {
        return this.getType().substring(this.getType().lastIndexOf(".") + 1).trim().toLowerCase();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvObject other = (EnvObject)obj;
        if (!this.name.equalsIgnoreCase(other.name)) {
            if (this.getPhisicalAddress().equalsIgnoreCase(other.getPhisicalAddress()) && this.getProtocol().equalsIgnoreCase(other.getProtocol())) {
                return !this.getPhisicalAddress().equalsIgnoreCase("unknown") && !this.getProtocol().equalsIgnoreCase("unknown");
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    public Set<String> getTagsList() {
        return this.tags;
    }

    public String getTagsString() {
        StringBuilder tagString = new StringBuilder();
        Boolean morethanone = false;
        for (String tag : this.getTagsList()) {
            if (tag.trim() == "") continue;
            if (morethanone.booleanValue()) {
                tagString.append(",");
            }
            tagString.append(tag.trim());
            morethanone = true;
        }
        return tagString.toString();
    }

    public void initTags() {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
    }
}

