/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.geometry;

import com.freedomotic.model.geometry.FreedomPoint;
import com.freedomotic.model.geometry.FreedomShape;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class FreedomPolygon
implements FreedomShape,
Serializable {
    private static final long serialVersionUID = -3740479951903880574L;
    private ArrayList<FreedomPoint> points = new ArrayList();

    public void append(FreedomPoint point) {
        this.points.add(point);
    }

    public void append(int x, int y) {
        FreedomPoint point = new FreedomPoint(x, y);
        this.points.add(point);
    }

    public FreedomPoint insert(FreedomPoint nextTo) {
        int index = this.points.indexOf(nextTo);
        FreedomPoint currentPoint = null;
        FreedomPoint nextPoint = null;
        try {
            nextPoint = this.points.get((index + 1) % this.points.size());
            currentPoint = this.points.get(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentPoint != null && nextPoint != null) {
            int x = Math.abs(currentPoint.getX() - nextPoint.getX()) / 2;
            int y = Math.abs(currentPoint.getY() - nextPoint.getY()) / 2;
            FreedomPoint newPoint = new FreedomPoint(x, y);
            this.points.add(index + 1, newPoint);
            return newPoint;
        }
        return null;
    }

    public void remove(FreedomPoint point) {
        this.points.remove(point);
    }

    public ArrayList<FreedomPoint> getPoints() {
        if (this.points != null) {
            return this.points;
        }
        return new ArrayList<FreedomPoint>();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.points.size() + " points ");
        for (FreedomPoint p : this.points) {
            buff.append("(").append(p.getX()).append(",").append(p.getY()).append(")");
        }
        return buff.toString();
    }
}

