/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.environment;

import com.freedomotic.model.geometry.FreedomPolygon;
import com.freedomotic.model.object.EnvObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class Zone
implements Serializable {
    private static final long serialVersionUID = 4668625650384850879L;
    private String name;
    private String description;
    private boolean room;
    private FreedomPolygon shape;
    @XmlTransient
    private ArrayList<EnvObject> objects;
    private String texture;
    private String uuid = UUID.randomUUID().toString();

    public String getName() {
        return this.name;
    }

    public FreedomPolygon getShape() {
        return this.shape;
    }

    public boolean isRoom() {
        return this.room;
    }

    public void setAsRoom(boolean room) {
        this.setRoom(room);
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTexture() {
        return this.texture;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShape(FreedomPolygon shape) {
        this.shape = shape;
    }

    public String toString() {
        return this.getName();
    }

    public void setTexture(String file) {
        this.texture = file;
    }

    @XmlTransient
    public ArrayList<EnvObject> getObjects() {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        return this.objects;
    }

    public void setObjects(ArrayList<EnvObject> objects) {
        this.objects = objects;
    }

    public void init() {
    }

    public void setChanged() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Zone other = (Zone)obj;
        return !(this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name));
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public void setRoom(boolean room) {
        this.room = room;
    }

    public String getUuid() {
        if (this.uuid == null || this.uuid.equals("")) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        if (uuid != null && !uuid.equals("")) {
            this.uuid = uuid;
        }
    }
}

