/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.environment;

import com.freedomotic.model.environment.Zone;
import com.freedomotic.model.geometry.FreedomColor;
import com.freedomotic.model.geometry.FreedomPolygon;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Environment
implements Serializable {
    private static final long serialVersionUID = 2461804483322891608L;
    private String name;
    private int width;
    private int height;
    private String renderer;
    private FreedomColor backgroundColor;
    private String backgroundImage;
    private ArrayList<Zone> zones = new ArrayList();
    private String uuid;

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    public String getEnvironmentName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public FreedomPolygon getShape() {
        return this.zones.get(0).getShape();
    }

    public FreedomColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBackgroundImage() {
        if (this.backgroundImage == null) {
            return "environment-map.png";
        }
        return this.backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Zone getZone(int index) {
        return this.zones.get(index);
    }

    public ArrayList<Zone> getZones() {
        return this.zones;
    }

    public int getLastZoneIndex() {
        return this.zones.size();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void clear() {
        this.zones.clear();
        this.zones = null;
        this.backgroundColor = null;
    }
}

