/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.ds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Tuples
implements Serializable {
    private static final long serialVersionUID = 3113993714552615957L;
    private final ArrayList<HashMap<String, String>> tuples = new ArrayList();

    public HashMap<String, String> getTuple(int i) {
        return this.tuples.get(i);
    }

    public String getProperty(int tupleIndex, String key) {
        return this.tuples.get(tupleIndex).get(key);
    }

    public Iterator<Map.Entry<String, String>> getPropertiesIterator(int tupleIndex) {
        return this.tuples.get(tupleIndex).entrySet().iterator();
    }

    public int getPropertiesCount(int tupleIndex) {
        return this.tuples.get(tupleIndex).entrySet().size();
    }

    public Set<Map.Entry<String, String>> getProperties(int tupleIndex) {
        return this.tuples.get(tupleIndex).entrySet();
    }

    public void add(HashMap<String, String> map) {
        this.tuples.add(map);
    }

    public int size() {
        return this.tuples.size();
    }

    public String getStringProperty(int tupleIndex, String key, String defaultValue) {
        String result = this.getProperty(tupleIndex, key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public int getIntProperty(int tupleIndex, String key, int defaultValue) {
        try {
            Integer result = Integer.parseInt(this.getProperty(tupleIndex, key));
            return result;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(int tupleIndex, String key, boolean defaultValue) {
        try {
            Boolean result = Boolean.parseBoolean(this.getProperty(tupleIndex, key));
            return result;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDoubleProperty(int tupleIndex, String key, double defaultValue) {
        Double result = null;
        try {
            String value = this.getProperty(tupleIndex, key);
            if (value != null) {
                result = Double.parseDouble(value);
            }
            if (result != null) {
                return result;
            }
            return defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void clear() {
        this.tuples.clear();
    }

    public boolean remove(int i) {
        return this.tuples.remove(i) != null;
    }
}

