/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.ds;

import com.freedomotic.model.ds.Tuples;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class Config
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class.getName());
    private static final long serialVersionUID = 1380975976029008480L;
    @XmlElement(name="props")
    private final Properties properties = new Properties();
    private String xmlFile = "";
    private final Tuples tuples = new Tuples();

    public String getXmlFile() {
        return this.xmlFile;
    }

    @XmlTransient
    public void setXmlFile(File file) {
        this.xmlFile = file.getName();
    }

    public void setXmlFile(String name) {
        this.xmlFile = name;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        String result = this.properties.getProperty(key);
        return result;
    }

    public Tuples getTuples() {
        return this.tuples;
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.properties.entrySet();
    }

    public void put(Object key, Object value) {
        this.properties.put(key, value);
    }

    public String getStringProperty(String key, String defaultValue) {
        String result = this.properties.getProperty(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            Integer result = Integer.parseInt(this.properties.getProperty(key));
            if (result != null) {
                return result;
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String result = this.properties.getProperty(key);
        if (result != null) {
            if (result.trim().equalsIgnoreCase("true")) {
                return true;
            }
            if (result.trim().equalsIgnoreCase("false")) {
                return false;
            }
        }
        return defaultValue;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        Double result = Double.parseDouble(this.properties.getProperty(key));
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public ArrayList<URL> getUrlListProperty(String key) {
        ArrayList<URL> list = new ArrayList<URL>();
        String s = this.getStringProperty(key, "");
        StringTokenizer t = new StringTokenizer(s, " ");
        while (t.hasMoreElements()) {
            String token = t.nextToken();
            try {
                list.add(new URL(token));
            }
            catch (MalformedURLException ex) {
                LOG.error(ex.getLocalizedMessage());
            }
        }
        return list;
    }

    public ArrayList<String> getPathListProperty(String key) {
        ArrayList<String> list = new ArrayList<String>();
        String s = this.getStringProperty(key, "");
        StringTokenizer t = new StringTokenizer(s, " ");
        while (t.hasMoreElements()) {
            String token = t.nextToken();
            try {
                list.add(token);
            }
            catch (Exception ex) {
                LOG.error(ex.getLocalizedMessage());
            }
        }
        return list;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        Set<Map.Entry<Object, Object>> entries = this.entrySet();
        Iterator<Map.Entry<Object, Object>> it = entries.iterator();
        StringBuilder string = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            string.append(key + "=" + value + "; ");
        }
        return string.toString();
    }
}

