/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.model.charting;

import com.freedomotic.model.charting.UsageData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UsageDataFrame
implements Serializable {
    public static final int FULL_UPDATE = 1;
    public static final int INCREMENTAL_UPDATE = 2;
    private int frameType;
    private List<UsageData> data;

    public UsageDataFrame(int type, List<UsageData> data) {
        this.frameType = type;
        this.data = data;
    }

    public UsageDataFrame() {
    }

    public int getFrameType() {
        return this.frameType;
    }

    public List<UsageData> getData() {
        return this.data;
    }

    public List<HashMap<String, String>> getDataAsMap() {
        ArrayList<HashMap<String, String>> lst = new ArrayList<HashMap<String, String>>();
        for (UsageData dat : this.data) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("address", dat.objaddress);
            map.put("uuid", dat.uuid);
            map.put("rowId", String.valueOf(dat.id));
            map.put("datetime", dat.datetime.toString());
            map.put("behavior", dat.objbehavior);
            map.put("name", dat.objname);
            map.put("protocol", dat.objprotocol);
            map.put("behaviorValue", dat.objvalue);
            lst.add(map);
        }
        return lst;
    }

    public void setDataFrameType(int type) {
        this.frameType = type;
    }

    public void setData(List<UsageData> data) {
        this.data = data;
    }

    public void addData(List<UsageData> data) {
        this.data.addAll(data);
    }
}

