/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.marketplace.util;

import com.freedomotic.marketplace.IPluginPackage;
import com.freedomotic.marketplace.util.DrupalRestHelper;
import com.freedomotic.marketplace.util.MarketPlaceFile;
import com.freedomotic.marketplace.util.MarketPlaceUser;
import com.freedomotic.marketplace.util.MarketPlaceValue;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MarketPlacePlugin2
implements IPluginPackage {
    private String nid;
    private String title;
    private String description;
    private String body;
    private String teaser;
    private ArrayList<MarketPlaceUser> field_developer;
    private ArrayList<MarketPlaceValue> field_status;
    private ArrayList<MarketPlaceValue> field_description;
    private ArrayList<MarketPlaceValue> field_category;
    private ArrayList<MarketPlaceValue> field_plugin_category;
    private ArrayList<MarketPlaceFile> field_icon;
    private ArrayList<MarketPlaceValue> field_os;
    private ArrayList<MarketPlaceFile> field_file;
    private String uri;
    private String type;
    @XmlTransient
    private transient ImageIcon icon;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getURI() {
        return "http://www.freedomotic.com/node/" + this.nid;
    }

    @Override
    @Deprecated
    @XmlTransient
    public String getFilePath() {
        if (this.field_file != null && this.field_file.size() > 0 && this.field_file.get(0) != null) {
            return this.field_file.get(0).getFilepath();
        }
        return "";
    }

    @Override
    public String getFilePath(String version) {
        if (this.field_file != null) {
            for (MarketPlaceFile marketPlaceFile : this.field_file) {
                if (marketPlaceFile == null || marketPlaceFile.getFilename() == null || !marketPlaceFile.getFilename().contains(version)) continue;
                String path = "http://www.freedomotic.com/sites/all/modules/pubdlcnt/pubdlcnt.php?file=" + marketPlaceFile.getFilepath() + "&nid=671";
                return path;
            }
        }
        return "";
    }

    public int getFileIndexByVersion(String version) {
        int i = -1;
        if (this.field_file != null) {
            for (MarketPlaceFile marketPlaceFile : this.field_file) {
                ++i;
                if (!marketPlaceFile.getFilename().contains(version)) continue;
                return i;
            }
        }
        return i + 1;
    }

    @XmlTransient
    public int getFileCount() {
        return this.field_file.size();
    }

    public ArrayList<MarketPlaceFile> getFiles() {
        if (this.field_file == null) {
            return new ArrayList<MarketPlaceFile>();
        }
        this.field_file.removeAll(Collections.singleton(null));
        return this.field_file;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.field_description.get(0).getValue();
    }

    @Override
    @XmlTransient
    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = this.field_icon != null && this.field_icon.size() > 0 && this.field_icon.get(0) != null ? DrupalRestHelper.retrieveImageIcon("/" + this.field_icon.get(0).getRelativeFilepath()) : DrupalRestHelper.defaultIconImage;
        }
        return this.icon;
    }

    public void addFile(MarketPlaceFile file) {
        String version = MarketPlacePlugin2.extractCorePluginVersion(file.getFilename());
        boolean found = false;
        for (MarketPlaceFile pluginFile : this.getFiles()) {
            if (pluginFile.getFilename() == null || !MarketPlacePlugin2.extractCorePluginVersion(pluginFile.getFilename()).equals(version)) continue;
            int index = this.field_file.indexOf(pluginFile);
            this.field_file.set(index, file);
            found = true;
        }
        if (!found) {
            this.field_file.add(file);
        }
    }

    public String formatBaseData() {
        return "\"type\":\"" + this.type + "\"," + "\"language\":\"und\"";
    }

    public String formatFieldCategory() {
        String jsonString = "";
        for (int i = 0; i < this.field_category.size(); ++i) {
            if (i == 0) {
                jsonString = jsonString + "\"field_category\":{";
            }
            jsonString = jsonString + "\"" + i + "\":" + this.field_category.get(i).formatValue();
            if (i != this.field_category.size() - 1) {
                jsonString = jsonString + ",";
            }
            if (i != this.field_category.size() - 1) continue;
            jsonString = jsonString + "}";
        }
        return jsonString;
    }

    public String formatFieldPluginCategory() {
        String jsonString = "";
        String s = "";
        jsonString = jsonString + "\"field_plugin_category\":{\"value\":{";
        boolean first = true;
        for (MarketPlaceValue value : this.field_plugin_category) {
            if (value.getValue() == null) continue;
            if (!first) {
                jsonString = jsonString + ",";
            }
            jsonString = jsonString + value.formatValueAsListElement();
            first = false;
        }
        jsonString = jsonString + "}}";
        return jsonString;
    }

    public String formatFieldOS() {
        String jsonString = "";
        String s = "";
        for (int i = 0; i < this.field_os.size(); ++i) {
            if (i == 0) {
                jsonString = jsonString + "\"field_os\":{\"value\":{";
            }
            s = this.field_os.get(i).getValue();
            jsonString = jsonString + "\"" + s + "\":\"" + s + "\"";
            if (i != this.field_os.size() - 1) {
                jsonString = jsonString + ",";
            }
            if (i != this.field_os.size() - 1) continue;
            jsonString = jsonString + "}}";
        }
        return jsonString;
    }

    public String formatFieldFile() {
        String jsonString = "";
        ArrayList<MarketPlaceFile> files = this.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            MarketPlaceFile pluginFile = files.get(i);
            pluginFile.setDescription(MarketPlacePlugin2.extractVersion(pluginFile.getFilename()));
            if (i == 0) {
                jsonString = jsonString + "\"field_file\":{";
            }
            jsonString = jsonString + "\"" + i + "\":{" + pluginFile.formatFile() + "}";
            if (i != files.size() - 1) {
                jsonString = jsonString + ",";
            }
            if (i != files.size() - 1) continue;
            jsonString = jsonString + "}";
        }
        return jsonString;
    }

    public static String extractCorePluginVersion(String filename) {
        String[] tokens = (filename = filename.substring(0, filename.lastIndexOf("."))).split("-");
        if (tokens.length == 3) {
            return tokens[1];
        }
        return filename;
    }

    public static String extractVersion(String filename) {
        String[] tokens = (filename = filename.substring(0, filename.lastIndexOf("."))).split("-");
        if (tokens.length == 3) {
            return tokens[1] + "-" + tokens[2];
        }
        return filename;
    }

    public ArrayList<MarketPlaceFile> getIcons() {
        if (this.field_icon == null) {
            return new ArrayList<MarketPlaceFile>();
        }
        this.field_icon.removeAll(Collections.singleton(null));
        return this.field_icon;
    }
}

