/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.marketplace.util;

import com.freedomotic.marketplace.IPluginPackage;
import com.freedomotic.marketplace.postplugin.JavaUploader;
import com.freedomotic.marketplace.util.MarketPlacePlugin2;
import com.freedomotic.marketplace.util.MarketPlacePluginCategory;
import com.freedomotic.marketplace.util.MarketPlacePluginResume;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class DrupalRestHelper {
    public static final String DRUPALSCHEMA = "http";
    public static final String DRUPALPATH = "www.freedomotic.com";
    public static final String DRUPALSERVICE = "rest";
    public static final String DEFAULTIMAGEPATH = "/sites/default/files/imagefield_default_images/Addons-64_0.png";
    public static ImageIcon defaultIconImage;

    public static List<IPluginPackage> retrieveAllPlugins() {
        ArrayList<IPluginPackage> pluginPackageList = new ArrayList<IPluginPackage>();
        ArrayList<MarketPlacePluginResume> resumes = DrupalRestHelper.retrieveResumes();
        for (MarketPlacePluginResume mpr : resumes) {
            if (mpr.getUri() == null) continue;
            pluginPackageList.add(mpr.getPlugin());
        }
        return pluginPackageList;
    }

    protected static ImageIcon retrieveImageIcon(String drupalRelativePath) {
        ImageIcon imageIcon = null;
        try {
            URI uri = new URI(DRUPALSCHEMA, DRUPALPATH, drupalRelativePath, "", "");
            URL url = uri.toURL();
            ImageIcon imgIcon = new ImageIcon(url);
            Image img = imgIcon.getImage();
            Image newimg = img.getScaledInstance(64, 64, 4);
            imageIcon = new ImageIcon(newimg);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(DrupalRestHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DrupalRestHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        return imageIcon;
    }

    protected static ArrayList<MarketPlacePluginResume> retrieveResumes() {
        ArrayList pluginList = new ArrayList();
        try {
            ClientResource cr = new ClientResource("http://www.freedomotic.com/rest/node?parameters[type]=plugin");
            Representation test2 = cr.get();
            String jsonData2 = test2.getText();
            Gson gson = new Gson();
            Type collectionType = new TypeToken<ArrayList<MarketPlacePluginResume>>(){}.getType();
            pluginList = (ArrayList)gson.fromJson(jsonData2, collectionType);
            defaultIconImage = DrupalRestHelper.retrieveImageIcon(DEFAULTIMAGEPATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pluginList;
    }

    public static ArrayList<MarketPlacePluginCategory> retrieveCategories() {
        ArrayList categoryList = new ArrayList();
        String jsonData = JavaUploader.postTaxonomyGetTree("5");
        Gson gson = new Gson();
        Type collectionType = new TypeToken<ArrayList<MarketPlacePluginCategory>>(){}.getType();
        categoryList = (ArrayList)gson.fromJson(jsonData, collectionType);
        return categoryList;
    }

    public static ArrayList<MarketPlacePlugin2> retrievePluginsByCategory(String categoryId) {
        ArrayList<MarketPlacePlugin2> pluginPackageList = new ArrayList<MarketPlacePlugin2>();
        int page = 0;
        boolean newData = true;
        String previousJsonData = "EMPTY";
        ArrayList pagePluginPackageList = new ArrayList();
        while (newData) {
            String jsonData = "";
            try {
                jsonData = JavaUploader.postTaxonomySelectNodes(categoryId, page);
                if (!jsonData.isEmpty()) {
                    if (page == 0 || !jsonData.equals(previousJsonData)) {
                        Gson gson = new Gson();
                        Type collectionType = new TypeToken<ArrayList<MarketPlacePlugin2>>(){}.getType();
                        pagePluginPackageList = (ArrayList)gson.fromJson(jsonData, collectionType);
                        pluginPackageList.addAll(pagePluginPackageList);
                        ++page;
                        previousJsonData = jsonData;
                        continue;
                    }
                    newData = false;
                    continue;
                }
                previousJsonData = "EMPTY";
                newData = false;
            }
            catch (Exception exception) {}
        }
        return pluginPackageList;
    }

    public static IPluginPackage retrievePluginPackage(String uri) {
        ClientResource cr = new ClientResource(uri);
        try {
            String jsonData = cr.get().getText();
            Gson gson = new Gson();
            Type collectionType = new TypeToken<MarketPlacePlugin2>(){}.getType();
            return (IPluginPackage)gson.fromJson(jsonData, collectionType);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

