/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.marketplace.postplugin;

import com.freedomotic.marketplace.postplugin.MarketPlacePluginFileField;
import com.freedomotic.marketplace.postplugin.PluginCategoryEnum;
import java.util.ArrayList;

public class MarketPlacePlugin {
    public static final String STATUS_PROOF_OF_CONCEPT = "Proof of Concept";
    public static final String STATUS_PROTOTYPE = "Prototype";
    public static final String STATUS_BETA_VERSION = "Beta Version";
    public static final String STATUS_STABLE_RELEASE = "Stable Release";
    public static final String OS_ALL = "All supported";
    public static final String OS_LINUX = "Linux";
    public static final String OS_WINDOWS = "Windows";
    public static final String OS_MAC = "Mac";
    public static final String OS_SOLARIS = "Solaris";
    private String title;
    private String body;
    private String path;
    private String field_developer;
    private String field_status;
    private String field_description;
    private PluginCategoryEnum field_category;
    private ArrayList<String> field_os;
    private MarketPlacePluginFileField field_file;
    private int field_file_position = 0;
    private ArrayList<String> taxonomy;

    public String toJson() {
        String pluginData = this.formatBaseData() + ",";
        pluginData = pluginData + "\"title\":\"" + this.getTitle() + "\",";
        pluginData = pluginData + "\"field_category\":[{\"value\":\"" + (Object)((Object)this.getField_category()) + "\"}]," + "\"field_developer\":{\"0\":{\"uid\":{\"uid\":\"" + this.getField_developer() + "\"}}},";
        pluginData = pluginData + "\"field_status\":[{\"value\":\"" + this.getField_status() + "\"}],";
        if (!"".equalsIgnoreCase(this.formatFieldOS())) {
            pluginData = pluginData + this.formatFieldOS() + ",";
        }
        if (!"".equalsIgnoreCase(this.formatTaxonomy())) {
            pluginData = pluginData + this.formatTaxonomy() + ",";
        }
        pluginData = pluginData + "\"field_description\":[{\"value\":\"" + this.getField_description() + "\"}],";
        if (!"".equalsIgnoreCase(this.formatFieldFile())) {
            pluginData = pluginData + this.formatFieldFile() + ",";
        }
        pluginData = pluginData + "\"body\":{\"und\":{\"0\":{\"value\":\"" + this.getBody() + "\"}}}" + "}";
        return pluginData;
    }

    public String formatBaseData() {
        return "{\"type\":\"plugin\",\"language\":\"und\"";
    }

    public String formatFieldOS() {
        String list = "";
        for (String s : this.field_os) {
            list = list + "\"" + s + "\":\"" + s + "\",";
        }
        if ("".equalsIgnoreCase(list)) {
            return "";
        }
        list = list.substring(0, list.length() - 1);
        return "\"field_os\":{\"value\":{" + list + "}}";
    }

    public String formatTaxonomy() {
        String list = "";
        for (String s : this.taxonomy) {
            list = list + s + " ";
        }
        if (list == "") {
            return "";
        }
        list = list.substring(0, list.length() - 1);
        return "\"taxonomy\":{\"tags\":{\"" + this.taxonomy.size() + "\":\"" + list + "\"}}";
    }

    public String formatFieldFile() {
        if (this.field_file != null) {
            return "\"field_file\":{\"" + this.field_file_position + "\":{" + this.field_file.formatFile() + "}}";
        }
        return "";
    }

    public String formatFieldCategory() {
        if (this.field_category != null) {
            return "\"field_category\":[{\"value\":\"" + (Object)((Object)this.getField_category()) + "\"}]";
        }
        return "";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getField_developer() {
        return this.field_developer;
    }

    public void setField_developer(String field_developer) {
        this.field_developer = field_developer;
    }

    public String getField_status() {
        return this.field_status;
    }

    public String getField_description() {
        return this.field_description;
    }

    public PluginCategoryEnum getField_category() {
        return this.field_category;
    }

    public void setField_status(String field_status) {
        this.field_status = field_status;
    }

    public void setField_description(String field_description) {
        this.field_description = field_description;
    }

    public void setField_category(PluginCategoryEnum field_category) {
        this.field_category = field_category;
    }

    public void addField_os(String os) {
        if (this.field_os == null) {
            this.field_os = new ArrayList();
        }
        if (!this.field_os.contains(os)) {
            this.field_os.add(os);
        }
    }

    public void removeField_os(String os) {
        if (this.field_os.contains(os)) {
            this.field_os.remove(os);
        }
    }

    public void setField_file(MarketPlacePluginFileField field_file) {
        this.setField_file(field_file, 0);
    }

    public void setField_file(MarketPlacePluginFileField field_file, int position) {
        this.field_file = field_file;
        this.field_file_position = position;
    }

    public void addTaxonomyWord(String word) {
        if (this.taxonomy == null) {
            this.taxonomy = new ArrayList();
        }
        if (!this.taxonomy.contains(word)) {
            this.taxonomy.add(word);
        }
    }

    public void removeTaxonomyWord(String word) {
        if (this.taxonomy.contains(word)) {
            this.taxonomy.remove(word);
        }
    }
}

