/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.marketplace.postplugin;

import com.freedomotic.marketplace.postplugin.MarketPlacePlugin;
import com.freedomotic.marketplace.util.MarketPlaceFile;
import com.freedomotic.marketplace.util.MarketPlacePlugin2;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.data.CookieSetting;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.engine.util.Base64;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class JavaUploader {
    public static final String DRUPALPATH = "http://www.freedomotic.com/";

    public static String parseUid(String loginResponse) {
        try {
            JsonReader reader = new JsonReader(new StringReader(loginResponse));
            reader.beginObject();
            String name = reader.nextName();
            while (!"user".equalsIgnoreCase(name)) {
                reader.nextString();
                name = reader.nextName();
            }
            reader.beginObject();
            String value = reader.nextString();
            reader.close();
            return value;
        }
        catch (IOException ex) {
            Logger.getLogger(JavaUploader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static CookieSetting parseCookie(String loginResponse) {
        try {
            String sessionId = "";
            String sessionName = "";
            JsonReader reader = new JsonReader(new StringReader(loginResponse));
            reader.beginObject();
            String name = reader.nextName();
            if ("sessid".equalsIgnoreCase(name)) {
                sessionId = reader.nextString();
            }
            if ("session_name".equalsIgnoreCase(name = reader.nextName())) {
                sessionName = reader.nextString();
            }
            reader.close();
            return new CookieSetting(0, sessionName, sessionId);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaUploader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String login(String username, String password) {
        ClientResource cr = new ClientResource("http://www.freedomotic.com//rest/user/login");
        String jsonData = "{\"username\":\"" + username + "\",\"password\":\"" + password + "\"}";
        JsonRepresentation jsonRep = new JsonRepresentation(jsonData);
        cr.setMethod(Method.POST);
        Response resp = cr.getResponse();
        if (resp.getStatus().isSuccess()) {
            try {
                return resp.getEntity().getText();
            }
            catch (IOException e) {
                System.out.println("IOException: " + e.getMessage());
            }
        } else {
            System.out.println(resp.getStatus().getName());
        }
        return null;
    }

    public static String postTaxonomyGetTree(String vocabularyNumber) {
        ClientResource cr2 = new ClientResource("http://www.freedomotic.com//rest/taxonomy_vocabulary/getTree");
        String text = "{\"vid\":\"" + vocabularyNumber + "\"}";
        cr2.setMethod(Method.POST);
        Representation rep2 = cr2.post(new JsonRepresentation(text));
        Response resp = cr2.getResponse();
        String jsonResponse = "";
        String nid = "";
        if (resp.getStatus().isSuccess()) {
            try {
                jsonResponse = resp.getEntity().getText();
                System.out.println(jsonResponse);
                return jsonResponse;
            }
            catch (IOException e) {
                System.out.println("IOException: " + e.getMessage());
            }
        } else {
            System.out.println(resp.getStatus().getName());
        }
        return "";
    }

    public static String postTaxonomySelectNodes(String taxonomyTreeNumber, int page) {
        try {
            ClientResource cr2 = new ClientResource("http://www.freedomotic.com//rest/taxonomy_term/selectNodes?page=" + page);
            String text = "{\"tids\":\"" + taxonomyTreeNumber + "\"}";
            cr2.setMethod(Method.POST);
            JsonRepresentation jsonRepresentation = new JsonRepresentation(text);
            if (jsonRepresentation != null) {
                Representation rep2 = cr2.post(jsonRepresentation);
                Response resp = cr2.getResponse();
                String jsonResponse = "";
                String nid = "";
                if (resp.getStatus().isSuccess()) {
                    try {
                        jsonResponse = resp.getEntity().getText();
                        System.out.println(jsonResponse);
                        return jsonResponse;
                    }
                    catch (IOException e) {
                        System.out.println("IOException: " + e.getMessage());
                    }
                } else {
                    System.out.println(resp.getStatus().getName());
                }
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        return "";
    }

    public static String postPlugin(CookieSetting cS, MarketPlacePlugin plugin) {
        ClientResource cr2 = new ClientResource("http://www.freedomotic.com//rest/node");
        cr2.getRequest().getCookies().add(cS);
        String pluginData = plugin.toJson();
        cr2.setMethod(Method.POST);
        Representation rep2 = cr2.post(new JsonRepresentation(pluginData));
        Response resp = cr2.getResponse();
        String jsonResponse = "";
        String nid = "";
        if (resp.getStatus().isSuccess()) {
            try {
                jsonResponse = resp.getEntity().getText();
                System.out.println(jsonResponse);
                JsonReader reader = new JsonReader(new StringReader(jsonResponse));
                reader.beginObject();
                String jsonName = reader.nextName();
                if (jsonName.equals("nid")) {
                    nid = reader.nextString();
                }
                reader.close();
            }
            catch (IOException e) {
                System.out.println("IOException: " + e.getMessage());
            }
        } else {
            System.out.println(resp.getStatus().getName());
        }
        return nid;
    }

    @Deprecated
    public static void putPlugin(CookieSetting cS, String nodeId, MarketPlacePlugin plugin) {
        Client client = new Client(new Context(), Protocol.HTTP);
        client.getContext().getParameters().add("use ForwardedForHeader", "false");
        ClientResource pluginResource = new ClientResource("http://www.freedomotic.com//rest/node/" + nodeId);
        pluginResource.setNext(client);
        pluginResource.getRequest().getCookies().add(cS);
        String pluginData = plugin.formatBaseData() + ",";
        pluginData = pluginData + plugin.formatFieldOS() + ",";
        pluginData = pluginData + "\"field_category\":{\"0\":{\"value\":\"" + (Object)((Object)plugin.getField_category()) + "\"}},";
        pluginData = pluginData + "\"field_plugin_category\":{\"0\":{\"value\":\"151\"}}";
        pluginData = pluginData + plugin.formatFieldFile();
        pluginData = pluginData + "}";
        Representation rep = pluginResource.put(new JsonRepresentation(pluginData));
        Response resp2 = pluginResource.getResponse();
        if (resp2.getStatus().isSuccess()) {
            try {
                System.out.println(resp2.getEntity().getText());
            }
            catch (IOException e) {
                System.out.println("IOException: " + e.getMessage());
            }
        } else {
            System.out.println(resp2.getStatus().getName());
        }
    }

    public static void putPlugin(CookieSetting cS, String nodeId, MarketPlacePlugin2 plugin) {
        Client client = new Client(new Context(), Protocol.HTTP);
        client.getContext().getParameters().add("use ForwardedForHeader", "false");
        ClientResource pluginResource = new ClientResource("http://www.freedomotic.com//rest/node/" + nodeId);
        pluginResource.setNext(client);
        pluginResource.getRequest().getCookies().add(cS);
        String pluginData = "{" + plugin.formatBaseData() + "," + plugin.formatFieldCategory() + "," + plugin.formatFieldPluginCategory() + "," + plugin.formatFieldOS() + "," + plugin.formatFieldFile() + "}";
        System.out.println("PluginData " + pluginData);
        Representation rep = pluginResource.put(new JsonRepresentation(pluginData));
        Response resp2 = pluginResource.getResponse();
        if (resp2.getStatus().isSuccess()) {
            try {
                System.out.println(resp2.getEntity().getText());
            }
            catch (IOException e) {
                System.out.println("IOException: " + e.getMessage());
            }
        } else {
            System.out.println(resp2.getStatus().getName());
        }
    }

    public static MarketPlaceFile postFile(CookieSetting cS, String uid, String pathName, String name) throws IOException {
        Client client = new Client(new Context(), Protocol.HTTP);
        client.getContext().getParameters().add("use ForwardedForHeader", "false");
        ClientResource testFileResource = new ClientResource("http://www.freedomotic.com//rest/file");
        testFileResource.setNext(client);
        testFileResource.getRequest().getCookies().add(cS);
        File zipFile = new File(pathName + "/" + name);
        int size = (int)zipFile.length();
        String base64String = Base64.encode(JavaUploader.fileToByteArray(zipFile), false);
        String fileData = "{\"uid\":\"" + uid + "\"," + "\"filename\":\"" + name + "\"," + "\"filesize\":\"" + size + "\"," + "\"file\":\"" + base64String + "\"" + "}";
        testFileResource.setMethod(Method.POST);
        Representation rep2 = testFileResource.post(new JsonRepresentation(fileData));
        Response resp = testFileResource.getResponse();
        String jsonResponse = "";
        String fid = "";
        if (resp.getStatus().isSuccess()) {
            try {
                jsonResponse = resp.getEntity().getText();
                System.out.println(jsonResponse);
                Gson gson = new Gson();
                Type collectionType = new TypeToken<MarketPlaceFile>(){}.getType();
                MarketPlaceFile pluginFile = (MarketPlaceFile)gson.fromJson(jsonResponse, collectionType);
                pluginFile.setFilename(name);
                return pluginFile;
            }
            catch (IOException e) {
                System.out.println("IOException: " + e.getMessage());
            }
        } else {
            System.out.println(resp.getStatus().getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByteArray(File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(JavaUploader.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return bos.toByteArray();
    }
}

