/*
 * Decompiled with CFR 0.152.
 */
package com.freedomotic.marketplace;

import com.freedomotic.marketplace.postplugin.JavaUploader;
import com.freedomotic.marketplace.util.DrupalRestHelper;
import com.freedomotic.marketplace.util.MarketPlaceFile;
import com.freedomotic.marketplace.util.MarketPlacePlugin2;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.restlet.data.CookieSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntUploader
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(AntUploader.class.getName());
    String username;
    String password;
    String nodeid;
    String attachment;

    @Override
    public void execute() {
        JavaUploader drupal = new JavaUploader();
        String loginJson = JavaUploader.login(this.username, this.password);
        CookieSetting cS = JavaUploader.parseCookie(loginJson);
        String userid = JavaUploader.parseUid(loginJson);
        if (cS != null) {
            LOG.info("Retrieving {} from the marketplace", (Object)this.nodeid);
            MarketPlacePlugin2 plugin = (MarketPlacePlugin2)DrupalRestHelper.retrievePluginPackage("http://www.freedomotic.com/rest/node/" + this.nodeid);
            if (plugin != null) {
                try {
                    File marketDirectory = new File(this.attachment);
                    File fileToUpload = this.findFileToUpload(marketDirectory);
                    if (fileToUpload == null) {
                        throw new BuildException("No marketplace files in folder " + marketDirectory);
                    }
                    MarketPlaceFile pluginFile = JavaUploader.postFile(cS, userid, marketDirectory.getAbsolutePath(), fileToUpload.getName());
                    plugin.addFile(pluginFile);
                    JavaUploader.putPlugin(cS, this.nodeid, plugin);
                }
                catch (IOException ex) {
                    throw new BuildException("Cannot find attachment file. " + ex.getMessage());
                }
            } else {
                throw new BuildException("There no exist a plugin with id: " + this.nodeid);
            }
        }
    }

    public File findFileToUpload(File marketDirectory) {
        File[] files = null;
        LOG.info("Uploading to drupal nodeid {} the file in \"{}\"", (Object)this.nodeid, (Object)marketDirectory.getAbsolutePath());
        if (!marketDirectory.isDirectory()) {
            throw new BuildException(marketDirectory + " is not a folder");
        }
        FileFilter objectFileFileter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && (file.getName().endsWith(".device") || file.getName().endsWith(".object") || file.getName().endsWith(".event"));
            }
        };
        files = marketDirectory.listFiles(objectFileFileter);
        File fileToUpload = files[0];
        return fileToUpload;
    }

    public String extractVersion(String filename) {
        String[] tokens = (filename = filename.substring(0, filename.lastIndexOf("."))).split("-");
        if (tokens.length == 3) {
            return tokens[1] + "-" + tokens[2];
        }
        return filename;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getNodeid() {
        return this.nodeid;
    }

    public void setNodeid(String nodeid) {
        this.nodeid = nodeid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

